# Gotchas:
# $xyx, $(xyz), ${xyz} and %xyx indicate variables to be replaced at runtime, please do NOT translate variable names
# & in button labels such as accessibility denotes the quick access letter
# buttons are fixed in length, so please make sure the translated strings will fit

# MAIN PAGE
LangString UseCD ${LANG_LATVIAN} "(Use CD)"
LangString ReadOnly ${LANG_LATVIAN} "(Read Only)"
LangString MainHeaderSubText ${LANG_LATVIAN} "Ldzu izvlieties jaun Ubuntu lietotja konta lietotjvrdu un paroli"
LangString MainLanguageLabel ${LANG_LATVIAN} "Valoda:"
LangString MainUsernameLabel ${LANG_LATVIAN} "Lietotjvrds:"
LangString MainPasswordLabel ${LANG_LATVIAN} "Parole:"
LangString MainInstallationSizeLabel ${LANG_LATVIAN} "Instalcijas izmrs (GB):"
LangString MainDistroLabel ${LANG_LATVIAN} "Darba vide:"
LangString MainInstallationDriveLabel ${LANG_LATVIAN} "Installation Drive ($freeSpace GB free):"

# TOOLTIPS
LangString MainLanguageToolTip ${LANG_LATVIAN} "Installation language."
LangString MainUsernameToolTip ${LANG_LATVIAN} "Please select a username for the new account.$\r$\nIt must be lower case.$\r$\nIt must not contain spaces.$\r$\nIt must contain only standard letters and numbers.$\r$\nIt cannot start by a number."
LangString MainPasswordToolTip ${LANG_LATVIAN} "Please select a password for the new account.$\r$\nIt must not contain spaces."
LangString MainInstallationSizeToolTip ${LANG_LATVIAN} "How many GB do you want to allocate?$\r$\n4GB is the bare minimum$\r$\n8GB is comfortable"
LangString MainInstallationDriveToolTip ${LANG_LATVIAN} "In which drive do you want to perform the installation?$\r$\nThis drive should have at least 5 GB free."
LangString Distro1ToolTip ${LANG_LATVIAN} "Ubuntu is the default."
LangString Distro2ToolTip ${LANG_LATVIAN} "Kubuntu uses the KDE3.5 desktop."
LangString Distro3ToolTip ${LANG_LATVIAN} "Kubuntu-KDE4 uses the KDE4 desktop."
LangString Distro4ToolTip ${LANG_LATVIAN} "Xubuntu is good for older systems."
LangString MainDistroToolTip ${LANG_LATVIAN} "What graphical environment do you want to install?$\r$\n* $(Distro1ToolTip)$\r$\n* $(Distro2ToolTip)$\r$\n* $(Distro3ToolTip)$\r$\n* $(Distro4ToolTip)"

# ERRORS
LangString ErrorNoUsername ${LANG_LATVIAN} "Please enter a valid username"
LangString ErrorSpaceInUsername ${LANG_LATVIAN} "Please do not use spaces in the username."
LangString ErrorUsernameUpperCase ${LANG_LATVIAN} "Please use all lower cases in the username."
LangString ErrorUsernameFirstCharNotLetter ${LANG_LATVIAN} "Your username must start with a letter."
LangString ErrorUsernameIllegalChars ${LANG_LATVIAN} "Your username must contain only standard letters and numbers."
LangString ErrorReservedUsername ${LANG_LATVIAN} "The selected username is reserved, please selected a different one."
LangString ErrorNoPassword ${LANG_LATVIAN} "Please enter a valid password."
LangString ErrorPasswordMismatch ${LANG_LATVIAN} "Passwords do not match."
LangString ErrorSpaceInPassword ${LANG_LATVIAN} "Please do not use spaces in the password."
LangString ErrorNoFreeSpace ${LANG_LATVIAN} "Not enough free space."
LangString ErrorNoKernel ${LANG_LATVIAN} "Could not retrieve some essential files"
LangString ErrorBcdedit ${LANG_LATVIAN} "Error while trying to execute bcdedit:"
LangString ErrorWubibcd ${LANG_LATVIAN} "Error while trying to execute wubibcd:"
LangString ErrorCD2ISO ${LANG_LATVIAN} "Could not access the CD, please make sure other applications are not using it and try again"
LangString ErrorDownload ${LANG_LATVIAN} "The download was interrupted with the error:"
LangString ErrorNoCD ${LANG_LATVIAN} "Could not find any appropriate CD"
LangString ErrorNoAdmin ${LANG_LATVIAN} "You must be logged in as administrator!"
LangString ErrorNoMemory ${LANG_LATVIAN} "You need at least ${MinMemoryMB}MB of memory to run the installer!"

# INSTALLER
LangString AboutToInstall ${LANG_LATVIAN} "You are about to install $Distro-$DistroVersion"
LangString InstallHeaderInitializing ${LANG_LATVIAN} "Installing $Distro-$DistroVersion"
LangString InstallSubHeader ${LANG_LATVIAN} "Please wait while the required files are retrieved and prepared"
LangString InstallHeaderUncompressWubifolder ${LANG_LATVIAN} "Uncompressing wubi folder..."
LangString InstallHeaderCopyIso ${LANG_LATVIAN} "Copying installation files..."
LangString InstallHeaderDownload ${LANG_LATVIAN} "Retrieving installation files, resume supported"
LangString InstallHeaderBackupIso ${LANG_LATVIAN} "Backing up installation files..."
LangString InstallHeaderWritePreseed ${LANG_LATVIAN} "Writing configuration files..."
LangString InstallHeaderWriteUninstaller ${LANG_LATVIAN} "Setting up uninstaller..."
LangString InstallHeaderWriteBootLoader ${LANG_LATVIAN} "Setting up bootloader..."
LangString InstallGenerateVirtualDisks ${LANG_LATVIAN} "Creating virtual disks..."
LangString InstallCopyFiles ${LANG_LATVIAN} "Copying installation files..."
LangString InstallCreateFolders ${LANG_LATVIAN} "Creating folders..."
LangString InstallRetrieveIso ${LANG_LATVIAN} "Retrieving installation files."

# UNINSTALLER
LangString UninstallAlreadyInstalled ${LANG_LATVIAN} "${AppName} is already installed"
LangString UninstallAsk ${LANG_LATVIAN} "Do you want to uninstall it?"
LangString UninstallMessageField ${LANG_LATVIAN} "$OldInstallationDrive\${DefaultInstallationDir} will be uninstalled.$\r$\nYou can backup your files if you want."
LangString UninstallBackupIsoCheckBox ${LANG_LATVIAN} "Backup downloaded files (CD ISO file)."
LangString UninstallBackupHomeCheckBox ${LANG_LATVIAN} "Backup personal documents (home.disk)."
LangString UninstallBackupLocationField ${LANG_LATVIAN} "Backup location: $BackupFolder"

# FINISH
LangString EjectRebootMsg ${LANG_LATVIAN} "Please remove any CD/DVD and reboot to complete the installation."
LangString RebootMsg ${LANG_LATVIAN} "Lai pabeigtu uzstdanu jums jprstart dators."

# DOWNLOADER
LangString MetadlDownloading ${LANG_LATVIAN} "Downloading installation files..."
LangString MetadlChecking ${LANG_LATVIAN} "Checking installation files..."
LangString MetadlConnecting ${LANG_LATVIAN} "Connecting to %s..."
LangString MetadlInitializing ${LANG_LATVIAN} "Initializing..."
LangString MetadlChecksums ${LANG_LATVIAN} "Calculating checksums..."
LangString MetadlRetrying1 ${LANG_LATVIAN} "Retrying in %d seconds... (%d of %d)"
LangString MetadlRetrying2 ${LANG_LATVIAN} "Retrying in %d seconds..."
LangString MetadlSecond ${LANG_LATVIAN} "second"
LangString MetadlSeconds ${LANG_LATVIAN} "seconds"
LangString MetadlProgress ${LANG_LATVIAN} "%s (%d%%) of %s @ %s/s"
LangString MetadlRemaining ${LANG_LATVIAN} " (%s remaining)"
LangString PleaseConnect ${LANG_LATVIAN} "Please connect to the internet now."

# ACCESSIBILITY
LangString MobilityAids ${LANG_LATVIAN} "Mobility Aids"
LangString VisibilityAids ${LANG_LATVIAN} "Visibility Aids"
LangString AccessibilityButton ${LANG_LATVIAN} "&Accessibility"
LangString AccessibilityText ${LANG_LATVIAN} "Accessibility profile"
LangString AccessibilitySubText ${LANG_LATVIAN} "Please select the appropriate accessibility profile"
LangString NoAccessibility ${LANG_LATVIAN} "None"
LangString VisibilityHighContrast ${LANG_LATVIAN} "High Contrast"
LangString VisibilityMagnifier ${LANG_LATVIAN} "Magnifier"
LangString VisibilityScreenReader ${LANG_LATVIAN} "Screen Reader"
LangString VisibilityBraille ${LANG_LATVIAN} "Braille Terminal"
LangString MobilityKeyboardModifiers ${LANG_LATVIAN} "Keyboard Modifiers"
LangString MobilityOnScreenKeyboard ${LANG_LATVIAN} "On-Screen Keyboard"

# CDBOOT
LangString CDBootTitle ${LANG_LATVIAN} "Install CD booter"
LangString CDBootText ${LANG_LATVIAN} "If your machine cannot boot off the CD, this program will install a new boot menu entry to help you boot from CD. In most cases this program is not needed, and it is sufficient to reboot with the CD-Rom in the tray.$\r$\n$\r$\nDo you want to proceed and install the CD booter?"

# BOOTMENU
LangString BootMenuNormal ${LANG_LATVIAN} "Start installer in normal mode"
LangString BootMenuSafeGraphics ${LANG_LATVIAN} "Start installer in safe graphic mode (only if you have display problems)"
LangString BootMenuACPI ${LANG_LATVIAN} "Start installer with ACPI workarounds (only if you have ACPI problems)"
LangString BootMenuVerbose ${LANG_LATVIAN} "Start installer in verbose mode"

# FAILURE-COMMAND
LangString FailureCommand ${LANG_LATVIAN} "The installation failed. Logs have been saved in: $INSTDIR\installation-logs.zip.$\r$\n$\r$\nNote that in verbose mode, the logs may include the password.$\r$\n$\r$\nThe system will now reboot."
